### GameState
- The GameState class implements the game logic and the rules.

#### Properties
- `board`: An object of the ChessRepository class that manages the game board and the pieces.

#### Methods
- `make_move(move)`: Makes the move on the board.
- `rollback(board, pieces)`: Rolls back the board and the pieces to the previous state.
- `get_board()`: Returns the ChessRepository object.
- `get_legal_moves(start)`: Returns the legal moves for the piece at the start square.
- `possible_moves()`: Returns all the possible moves for the current player.
- `play_random_move([moves])`: Plays a random legal move from the list of moves, otherwise it first gets the list of all the possible moves and then plays a random move from that list.
- `get_value()`: Returns the value of the current position. The value is positive if white is winning and negative if black is winning.
- `get_result()`: Returns the result of the game. It can be either `1` (white wins), `0` (black wins), `0.5` (draw) or `None` (game is not over).
- `is_insufficient_material()`: Returns `True` if the game is a draw due to insufficient material and `False` otherwise.
- `fen()`: Returns the FEN string of the current position.
- `game_over()`: Returns `True` if the game is over and `False` otherwise.

#### Example
```python
chess_repository = ChessRepository()
chess_repository.initialize_board()
game_state = GameState(chess_repository)
print(game_state.get_value())
# Output: 0

print(game_state.get_legal_moves("d2")
# Output: [(2, 3), (3, 3)]

game_state.make_move("d2d4")
print(game_state.get_board())
# Output: A ChessRepository object with the board after the move
```