### ConvolutionalNeuralNetwork
- This class is used to create, train, save, load, and predict the results of the Convolutional Neural Network.
- The model has two branches, one for the board and one for the turn: 
  -  The board branch is a convolutional neural network that takes in the board as a tensor and outputs a tensor.
  - The turn branch is a fully connected neural network that takes in the turn as a tensor and outputs a tensor.
- The two branches are then merged and passed through a series of fully connected layers. The output layer is a fully connected layer with 3 nodes, one for each possible result. The model is compiled with the Adam optimizer, categorical crossentropy loss, and accuracy metric. 
- The model is trained for 128 epochs with a batch size of 64 and a validation split of 0.3.

#### Properties
- input_board: The input layer for the board branch
- input_turn: The input layer for the turn branch
- model: The model of the neural network

#### Methods
- `train(path)`: Train the model with the dataset at the given path.
- `predict(fen=None, board_tensor=None, turn_tensor=None)`: Predict the result of the given board and turn.
- `save(path)`: Save the model to the given path.
- `load(path)`: Load the model from the given path.
- `preprocess_data(path)`: Preprocess the dataset at the given path.

#### Example 
```python
# Create the model
model = ConvolutionalNeuralNetwork()

# Train the model
model.train("Resources/training_dataset.json")

# Predict the result
model.predict("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1")

# Output = [0. 1. 0.] (draw)
```

