﻿#pragma warning(disable : 4996)
#pragma comment(lib, "ws2_32.lib")
#include <WINSOCK2.H>
#include <iostream>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <windows.h>
#include <conio.h>
using namespace std;
char message[10000];
#define port 5150           //端口号
SOCKET sclient;

class Chessboard;
class Chess
{
private:
	int Id;

public:
	Chess(int x) : Id(x) {}
	int Get() //取ID
	{
		return Id;
	}
	virtual bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy) = 0; //判断走步合理性
	virtual ~Chess() {}
};
class Chessboard
{
private:
	Chess* c[10][11]; //棋盘：X为横（9），Y为纵（10），从1开始记
	char Chessword[15][4] = { "兵", "炮", "車", "马", "相", "士", "帅", " ", "将", "士", "象", "马", "車", "炮", "卒" };

public:
	static int Player; //上半区为1，下半区为-1
	static bool End;   //判断是否结束
	static int Times;  //重开局数
	static int P1;     //P1获胜局数
	static int P2;     //P2获胜局数
	Chessboard();
	Chess* Get(int x, int y);                              //返回指定点的指针
	void Set(int x,int y,int id);
	int Getid(int x, int y);                               //返回指定点处棋子ID的指针
	bool Move(int startx, int starty, int endx, int endy); //移动
	void Init();                                           //初始化棋子
	void Show();                                           //打印
	void Play();                                           //开始游戏
	~Chessboard();
};
int Chessboard::Player = 1;
int Chessboard::Times = 0;
int Chessboard::P1 = 0;
int Chessboard::P2 = 0;
bool Chessboard::End = true;
class General : public Chess //帅，ID为-1和1
{
public:
	General(int i) : Chess((i == 0 ? -1 : 1)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = startx - endx;
		int TempY = starty - endy;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (TempX * TempX + TempY * TempY == 1) && (endx >= 4 && endx <= 6) && (endy >= 1 && endy <= 3 || endy >= 8 && endy <= 10))
		{
			return true;
		}
		return false;
	}
	~General()
	{
		Chessboard::End = false;
	}
};
class BodyGuard : public Chess //士，ID为-2和2
{
public:
	BodyGuard(int i) : Chess((i == 0 ? -2 : 2)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = startx - endx;
		int TempY = starty - endy;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (TempX * TempX + TempY * TempY == 2) && (endx >= 4 && endx <= 6) && (endy >= 1 && endy <= 3 || endy >= 8 && endy <= 10))
		{
			return true;
		}
		return false;
	}
};
class Chancellor : public Chess //相，ID为-3和3
{
public:
	Chancellor(int i) : Chess((i == 0 ? -3 : 3)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = endx - startx;
		int TempY = endy - starty;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (TempX * TempX + TempY * TempY == 8) && (endx % 2 != 0 && endx >= 1 && endy <= 9) && ((starty - 1) / 5 == (endy - 1) / 5) && !ch.Get(startx + (TempX / 2), starty + (TempY / 2)))
		{
			return true;
		}
		return false;
	}
};
class Horse : public Chess //马，ID为-4和4
{
public:
	Horse(int i) : Chess((i == 0 ? -4 : 4)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = endx - startx;
		int TempY = endy - starty;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (TempX * TempX + TempY * TempY == 5) && !ch.Get(startx + (TempX / 2), starty + (TempY / 2)))
		{
			return true;
		}
		return false;
	}
};
class Chariot : public Chess //車，ID为-5和5
{
public:
	Chariot(int i) : Chess((i == 0 ? -5 : 5)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = startx - endx;
		int TempY = starty - endy;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (!(TempX && TempY)) && (TempX + TempY))
		{
			if (TempX)
			{
				int Sign = (TempX > 0 ? -1 : 1);
				for (int i = 1; i < fabs(TempX); i++)
				{
					if (ch.Get(startx + Sign * i, starty))
					{
						return false;
					}
				}
			}
			else
			{
				int Sign = (TempY > 0 ? -1 : 1);
				for (int i = 1; i < fabs(TempY); i++)
				{
					if (ch.Get(startx, starty + Sign * i))
					{
						return false;
					}
				}
			}
			return true;
		}
		return false;
	}
};
class Cannon : public Chess //炮，ID为-6和6
{
public:
	Cannon(int i) : Chess((i == 0 ? -6 : 6)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = startx - endx;
		int TempY = starty - endy;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (!(TempX && TempY)) && (TempX + TempY))
		{
			int Tmp = 0;
			if (TempX)
			{
				int Sign = (TempX > 0 ? -1 : 1);
				for (int i = 1; i < fabs(TempX); i++)
				{
					if (ch.Get(startx + Sign * i, starty))
					{
						Tmp++;
					}
				}
			}
			else
			{
				int Sign = (TempY > 0 ? -1 : 1);
				for (int i = 1; i < fabs(TempY); i++)
				{
					if (ch.Get(startx, starty + Sign * i))
					{
						Tmp++;
					}
				}
			}
			if (E_Id)
			{
				if (Tmp == 1)
				{
					return true;
				}
			}
			else
			{
				if (!Tmp)
				{
					return true;
				}
			}
		}
		return false;
	}
};
class Soldier : public Chess //兵，ID为-7和7
{
public:
	Soldier(int i) : Chess((i == 0 ? -7 : 7)) {}
	bool Judgement(Chessboard& ch, int startx, int starty, int endx, int endy)
	{
		int TempX = startx - endx;
		int TempY = starty - endy;
		int S_Id = ch.Getid(startx, starty);
		int E_Id = ch.Getid(endx, endy);
		if ((S_Id * E_Id <= 0) && (S_Id * TempY <= 0))
		{
			if (fabs(TempY) == 1 && TempX == 0)
			{
				return true;
			}
			if (fabs(TempX) == 1 && TempY == 0)
			{
				if (((starty - 1) / 5 == 0 && S_Id < 0) || ((starty - 1) / 5 == 1 && S_Id > 0))
				{
					return true;
				}
			}
		}
		return false;
	}
};
inline Chessboard::Chessboard()
{
	memset(c, 0, sizeof(c));
}
inline Chess* Chessboard::Get(int x, int y)
{
	return c[x][y];
}
int Chessboard::Getid(int x, int y)
{
	if (c[x][y] != 0)
	{
		return c[x][y]->Get();
	}
	return 0;
}
bool Chessboard::Move(int startx, int starty, int endx, int endy)
{
	if (startx >= 1 && startx <= 9 && starty >= 1 && starty <= 10 && endx >= 1 && endx <= 9 && endy >= 1 && endy <= 10 && Getid(startx, starty) && Getid(startx, starty) * Player > 0 && c[startx][starty]->Judgement(*this, startx, starty, endx, endy))
	{
		if (c[endx][endy] != 0)
		{
			delete c[endx][endy]; //吃子
		}
		c[endx][endy] = c[startx][starty];
		c[startx][starty] = 0;
		//Player *= -1; //更换玩家操作
		int k = 0;
		for (int i = 1; i < 10; i++)
			for (int j = 1; j < 11; j++)
				message[k++] = Getid(i, j) + 50;
		send(sclient, message, 10000, 0);
		return true;
	}
	else
	{
		cout << "走错了！" << endl;
		return false;
	}
}
void Chessboard::Set(int x,int y,int id)
{
	if (id == 1)
		c[x][y] = new General(1);
	else if (id == -1)
		c[x][y] = new General(0);
	else if (id == 2)
		c[x][y] = new BodyGuard(1);
	else if (id == -2)
		c[x][y] = new BodyGuard(0);
	else if (id == 3)
		c[x][y] = new Chancellor(1);
	else if (id == -3)
		c[x][y] = new Chancellor(0);
	else if (id == 4)
		c[x][y] = new Horse(1);
	else if (id == -4)
		c[x][y] = new Horse(0);
	else if (id == 5)
		c[x][y] = new Chariot(1);
	else if (id == -5)
		c[x][y] = new Chariot(0);
	else if (id == 6)
		c[x][y] = new Cannon(1);
	else if (id == -6)
		c[x][y] = new Cannon(0);
	else if (id == 7)
		c[x][y] = new Soldier(1);
	else if (id == -7)
		c[x][y] = new Soldier(0);
	else
		c[x][y] = 0;
}

void Chessboard::Init()
{
	c[1][1] = new Chariot(1);
	c[9][1] = new Chariot(1);
	c[2][1] = new Horse(1);
	c[8][1] = new Horse(1);
	c[3][1] = new Chancellor(1);
	c[7][1] = new Chancellor(1);
	c[4][1] = new BodyGuard(1);
	c[6][1] = new BodyGuard(1);
	c[5][1] = new General(1);
	c[2][3] = new Cannon(1);
	c[8][3] = new Cannon(1);
	c[1][4] = new Soldier(1);
	c[3][4] = new Soldier(1);
	c[5][4] = new Soldier(1);
	c[7][4] = new Soldier(1);
	c[9][4] = new Soldier(1);
	c[1][10] = new Chariot(0);
	c[9][10] = new Chariot(0);
	c[2][10] = new Horse(0);
	c[8][10] = new Horse(0);
	c[3][10] = new Chancellor(0);
	c[7][10] = new Chancellor(0);
	c[4][10] = new BodyGuard(0);
	c[6][10] = new BodyGuard(0);
	c[5][10] = new General(0);
	c[2][8] = new Cannon(0);
	c[8][8] = new Cannon(0);
	c[1][7] = new Soldier(0);
	c[3][7] = new Soldier(0);
	c[5][7] = new Soldier(0);
	c[7][7] = new Soldier(0);
	c[9][7] = new Soldier(0);
}
void Chessboard::Show()
{
	cout << endl;
	HANDLE handle;
	handle = GetStdHandle(STD_OUTPUT_HANDLE);
	SetConsoleTextAttribute(handle, 0xF0);
	cout << "         1   2   3   4   5   6   7   8   9 " << endl
		<< endl;
	char num[11][4] = { " 0", " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10" };
	for (int i = 1; i < 11; i++)
	{
		if (i == 6)
		{
			SetConsoleTextAttribute(handle, 0xFC);
			cout << "                  楚河       汉界        " << endl;
		}
		SetConsoleTextAttribute(handle, 0xF0);
		cout << "     " << num[i] << "  ";
		for (int j = 1; j < 10; j++)
		{
			if (c[j][i] != NULL)
			{
				if (c[j][i]->Get() > 0)
				{
					SetConsoleTextAttribute(handle, 0xF0);
					cout << Chessword[c[j][i]->Get() + 7];
					if (j < 9)
					{
						if (i < 6)
							SetConsoleTextAttribute(handle, 0xF0);
						else
							SetConsoleTextAttribute(handle, 0xFC);
						cout << "—";
					}
				}
				else
				{
					SetConsoleTextAttribute(handle, 0xFC);
					cout << Chessword[c[j][i]->Get() + 7];
					if (j < 9)
					{
						if (i < 6)
							SetConsoleTextAttribute(handle, 0xF0);
						else
							SetConsoleTextAttribute(handle, 0xFC);
						cout << "—";
					}
				}
			}
			else
			{
				if (i < 6)
					SetConsoleTextAttribute(handle, 0xF0);
				else
					SetConsoleTextAttribute(handle, 0xFC);
				if (j < 9)
					cout << "+-—";
				else
					cout << "+";
			}
		}
		if (i != 5)
			cout << endl;
		if (i < 10 && i != 5)
		{
			if (i < 6)
				SetConsoleTextAttribute(handle, 0xF0);
			else
				SetConsoleTextAttribute(handle, 0xFC);
			if (i == 1 || i == 8)
				cout << "         |   |   |   | \\ | / |   |   |   |";
			else if (i == 2 || i == 9)
				cout << "         |   |   |   | / | \\ |   |   |   |";
			else
				cout << "         |   |   |   |   |   |   |   |   |";
		}
		cout << endl;
	}
	cout << endl;
	

	
	
	
}
void Chessboard::Play()
{
	
	HANDLE handle;
	handle = GetStdHandle(STD_OUTPUT_HANDLE);
	SetConsoleTextAttribute(handle, 0xFC);
	system("cls");
	this->Init();
	this->Show();
	

	do
	{
		int startx, starty, aimx, aimy, iflag;
		int sid, aid;
		
		
		if (Player == 1)
		{

			do
			{
				sid = aid = 0;
				
				SetConsoleTextAttribute(handle, 0xFC);
				
				cout << "P1"  << " 起始位置 目标位置：" << endl;

				while (1) // 读入数据
				{

					Player *= -1; //更换玩家操作
					cin >> starty >> startx >> aimy >> aimx;
					if ((int)starty >= 1 && (int)starty <= 10 && (int)startx >= 1 && (int)startx <= 9 && (int)aimy >= 1 && (int)aimy <= 10 && (int)aimx >= 1 && (int)aimx <= 9)
						break;
					cin.clear();
					cin.sync();
					cout << "打错了！" << endl;
				}
		
			} while (!this->Move(startx, starty, aimx, aimy));
		}
			
			else if (Player == -1)
			{
				int len = recv(sclient, message, 10000, 0);
				int k = 0;
				for (int i = 1; i < 10; i++)
					for (int j = 1; j < 11; j++)
					{
						Set(i, j, message[k++] - 50);
					}
				system("cls"); // 刷屏
				this->Show();
				Player *=-1;
			}
		
		
		
		system("cls"); // 刷屏
		this->Show();

		

		for (int i = 4; i < 7; i++) // 将帅会面特判
		{
			iflag = 0;
			for (int j = 1; j < 11; j++)
			{
				if (c[i][j] != 0)
				{
					if ((int)fabs(c[i][j]->Get()) == 1)
					{
						iflag++;
					}
					if (iflag == 1 && (int)fabs(c[i][j]->Get()) != 1)
					{
						iflag = 0;
						break;
					}
				}
			}
			if (iflag == 2)
			{
				Player *= -1;
				Chessboard::End = false;
			}
		}
	} while (Chessboard::End);
	if ((Chessboard::Player == 1 ? 1 : 2) == 1)
	{
		SetConsoleTextAttribute(handle, 0xFC);
	}
	else
	{
		SetConsoleTextAttribute(handle, 0xF0);
	}
	int winner;
	if (Chessboard::Player == 1)
	{
		winner = 1;
		Chessboard::P1++;
	}
	else
	{
		winner = 2;
		Chessboard::P2++;
	}
	cout << "Player " << winner << "获胜！"
		<< "（" << P1 << ":" << P2 << "）" << endl;
	cout << "再来一盘？（Y/N）" << endl;
	char c;
	while (c = getchar()) // 重开比赛
	{
		if (c == 'Y')
		{
			Chessboard New;
			Chessboard::End = true;
			Chessboard::Times++;
			if (Times % 2)
				Chessboard::Player = 1;
			else if (Times % 2 == 0)
				Chessboard::Player = -1;
			New.Play();
		}
		else if (c == 'N')
		{
			cout << "最终比分"
				<< " " << P1 << ":" << P2 << " " << endl;
			system("pause");
			exit(0);
		}
	}
}
Chessboard::~Chessboard()
{
	for (int i = 0; i < 10; i++)
	{
		for (int j = 0; j < 11; j++)
		{
			if (c[i][j] != 0)
			{
				delete c[i][j];
				c[i][j] = 0;
			}
		}
	}
}
int main()
{
	system("mode con cols=50 lines=30");
	WSADATA data;
	WSAStartup(0x0202, &data); //创建套节字
	SOCKADDR_IN server;
	server.sin_family = AF_INET;                // 使用 TCP/IP 协议簇
	server.sin_port = htons(port);              //服务器端口号
	server.sin_addr.s_addr = htonl(INADDR_ANY); // 指向 客户端 的 IP 地址
	int sizes = sizeof(SOCKADDR_IN);
	SOCKET slisten = socket(AF_INET /* 使用 TCP/IP 协议簇 */, SOCK_STREAM, IPPROTO_TCP);
	bind(slisten, (struct sockaddr*)&server, sizeof(SOCKADDR_IN));
	listen(slisten, 1);
	SOCKADDR client;
	cout << "test";
	sclient = accept(slisten, (struct sockaddr*)&client, &sizes); // 等待连接
	printf("成功连接上服务端\n");
	Chessboard C;
	C.Play();
}