package cn.yd.badminton.controller;

import cn.yd.badminton.po.*;
import cn.yd.badminton.service.*;
import com.baidu.aip.nlp.AipNlp;
import com.github.pagehelper.util.StringUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Controller
@Transactional
@RequestMapping("/user")
public class UserController {
    @Autowired
    private AppraisalService appraisalService;
    @Autowired
    private AppraisalpicService appraisalpicService;
    @Autowired
    private ReservationService reservationService;
    @Autowired
    private AreaService areaService;
    @Autowired
    private UserService userService;

    // 检验用户是否注册
    @RequestMapping("/regist")
    @ResponseBody
    public List<User> testRegist(String username) throws Exception {

        System.out.println(username);
        List<User> userList = userService.findUser(username);
        return userList;
    }

    // 注册
    @RequestMapping("/register")
    public String toRegister(User user) throws Exception {

        userService.toRegist(user);

        return "home";
    }

    // 登录
    @RequestMapping("/findUserToLogin")
    public String findUserToLogin(Model model, HttpSession session, User userRes) throws Exception {

        try {
            List<Area> areaList = areaService.findAllAreas1();
            model.addAttribute("areaList", areaList);

            User user = userService.findUserLogin(userRes);

            session.setAttribute("userR", user);

        } catch (Exception e) {
            model.addAttribute("mess", e.getMessage());
            return "login"; // 返回登陆界面
        }
        return "home";// 进入home界面
    }

    // 情感分析
    public static final String APP_ID = "16709917";
    public static final String API_KEY = "GeTfDxNoDngleIpAes9ep0fj";
    public static final String SECRET_KEY = "YRR0ECrVPuCuFCeO1nNF1liabrl7CeaC";

    // 添加评价
    @RequestMapping(value = "/insertAppraisal", method = { RequestMethod.POST })
    public String insertAppraisal(Model model, List<MultipartFile> fileList, Appraisal appraisal) throws Exception {
        try {
            // 将评论内容添加到评论库
            appraisal.setAppTime(new Date());
            appraisalService.InsertIntoAppraisal(appraisal);
            // 将评论的相关图片添加到评论图片库
            for (MultipartFile file : fileList) {
                if (!file.isEmpty()) {
                    Appraisalpic appraisalpic = new Appraisalpic();
                    appraisalpic.setAppraisalId(appraisal.getAppraisalId());
                    FastDFSClient client = new FastDFSClient(
                            "F:\\IDE-Project\\Badminton\\src\\main\\resources\\client.conf");
                    String str = client.uploadFile(file.getBytes(), "jpg");
                    appraisalpic.setPic(str);
                    appraisalpicService.saveAppraisalPic(appraisalpic);
                }
            }
            // 下面是情感分析的内容
            AipNlp client = new AipNlp(APP_ID, API_KEY, SECRET_KEY);
            // 传入可选参数调用接口
            HashMap<String, Object> options = new HashMap<String, Object>();
            // 情感倾向分析
            JSONObject res = client.sentimentClassify(appraisal.getInfo(), options);
            JsonParser parser = new JsonParser();
            JsonObject job = (JsonObject) parser.parse(res.toString());
            JsonArray array = job.get("items").getAsJsonArray();
            JsonObject suJsonObject = array.get(0).getAsJsonObject();
            double shu = Double.valueOf(suJsonObject.get("positive_prob").toString());
            shu = (double) Math.round(shu * 100) / 100;
            Area areaRes = areaService.findAreaById(appraisal.getAreaId());
            int good_com = areaRes.getGoodNum();
            int bad_com = areaRes.getBadNum();
            if (shu > 0.4) {
                good_com++;
            } else {
                bad_com++;
            }
            double favo_rate = (double) good_com / (good_com + bad_com) * 100;
            areaRes.setGoodNum(good_com);
            areaRes.setBadNum(bad_com);
            areaRes.setGoodRate((int) favo_rate);
            areaService.updateAreaComment(areaRes);
            // 返回场地预览页面
            return "area/areaList";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "area/areaList";
        }

    }

    // 查询自己的评价
    @RequestMapping("/findAppraisal")
    public String findAppraisal(Model model, Appraisal appraisal) throws Exception {
        try {
            List<AppraisalCustom> appraisalCustomList = appraisalService.findAppraisalByareaid(appraisal.getUserId());
            model.addAttribute("appraisalCustomList", appraisalCustomList);
            return "jsp/appraisal/userAppraisalList";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "error";
        }
    }

    // 查看某个场地的用户评价
    @RequestMapping("/findAreaAppraisal")
    public String findAreaAppraisal(Model model, Appraisal appraisal) throws Exception {
        try {
            List<AppraisalCustom> appraisalCustomList = appraisalService.findAppraisalByareaid(appraisal.getAreaId());
            model.addAttribute("appraisalCustomList", appraisalCustomList);
            return "jsp/appraisal/appraisalList";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "error";
        }
    }

    // 删除评价
    @RequestMapping("/deleteAppraisal")
    public String deleteAppraisal(Model model, Appraisal appraisal) throws Exception {
        try {
            // 删除相关评论
            appraisalService.deleteAppraisal(appraisal);
            Appraisalpic appraisalpic = new Appraisalpic();
            return "appraisal/userAppraisalList";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "appraisal/userAppraisalList";
        }

    }

    // 查看一个场地的全部信息
    @RequestMapping("/searchAreaDetail")
    public String searchAreaDetail(Model model, Area area) throws Exception {
        try {
            List<Area> areaList = areaService.findAllAreas1();
            model.addAttribute("areaList", areaList);
            // System.out.println("啊实打实的:"+areaList.get(1).getGoodRate());
            System.out.println("场地的主键:" + area.getAreaId());
            AreaCustom areaCustom = areaService.findAreaDetail(area);
            System.out.println("场地的名称:" + areaCustom.getAreaname());
            model.addAttribute("area", areaCustom);
            return "introduce";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "error";
        }
    }

    // //查看场地的预定情况
    // @RequestMapping("/searchAreaReservation")
    // public String searchAreaReservation(Model model,HttpSession
    // session,Reservation reservation1) {
    // try {
    // List<AreaCustom> areaCustomList =
    // areaService.selectAreaReservation(reservation1);
    // for (AreaCustom areacustom : areaCustomList) {
    // Integer[] time_status = areacustom.getTime_status();
    // for (int i = 0; i < 13; i++) {
    // time_status[i] = -1;
    // }
    // for (Reservation reservation : areacustom.getReservationList()) {
    // User this_user = (User) session.getAttribute("userR");
    // Integer th_userId = this_user.getUserId();
    // if (th_userId.equals(reservation.getUserId()))
    // {
    // switch (reservation.getStarttime()) {
    // case 8:
    // time_status[0] = reservation.getPreStatus();
    // break;
    // case 9:
    // time_status[1] = reservation.getPreStatus();
    // break;
    // case 10:
    // time_status[2] = reservation.getPreStatus();
    // break;
    // case 11:
    // time_status[3] = reservation.getPreStatus();
    // break;
    // case 12:
    // time_status[4] = reservation.getPreStatus();
    // break;
    // case 13:
    // time_status[5] = reservation.getPreStatus();
    // break;
    // case 14:
    // time_status[6] = reservation.getPreStatus();
    // break;
    // case 15:
    // time_status[7] = reservation.getPreStatus();
    // break;
    // case 16:
    // time_status[8] = reservation.getPreStatus();
    // break;
    // case 17:
    // time_status[9] = reservation.getPreStatus();
    // break;
    // case 18:
    // time_status[10] = reservation.getPreStatus();
    // break;
    // case 19:
    // time_status[11] = reservation.getPreStatus();
    // break;
    // case 20:
    // time_status[12] = reservation.getPreStatus();
    // break;
    // }
    // }
    // else
    // {
    // switch (reservation.getStarttime()) {
    // case 8:
    // time_status[0] = 3;
    // break;
    // case 9:
    // time_status[1] = 3;
    // break;
    // case 10:
    // time_status[2] = 3;
    // break;
    // case 11:
    // time_status[3] = 3;
    // break;
    // case 12:
    // time_status[4] = 3;
    // break;
    // case 13:
    // time_status[5] = 3;
    // break;
    // case 14:
    // time_status[6] = 3;
    // break;
    // case 15:
    // time_status[7] = 3;
    // break;
    // case 16:
    // time_status[8] = 3;
    // break;
    // case 17:
    // time_status[9] = 3;
    // break;
    // case 18:
    // time_status[10] = 3;
    // break;
    // case 19:
    // time_status[11] = 3;
    // break;
    // case 20:
    // time_status[12] = 3;
    // break;
    // }
    // }
    // areacustom.setTime_status(time_status);
    // }
    // }
    // model.addAttribute("areaCustomList", areaCustomList);
    // return "";
    // } catch (Exception e) {
    // model.addAttribute("error", e.getMessage());
    // return "";
    // }
    // }
    // //预定场地
    // @RequestMapping("/reserveArea")
    // public String reserveArea(Model model,Reservation[] reservationList){
    // try {
    // for (Reservation reservation:reservationList) {
    // reservation.setPreStatus(0);
    // reservationService.saveReservation(reservation);
    // }
    // return "area/areaList";
    // }catch (Exception e){
    // model.addAttribute("error",e.getMessage());
    // return "area/areaList";
    // }
    // }
    // 查询自己的预约场地
    @RequestMapping("/searchReservation")
    public String searchReservation(Model model, Reservation reservation) {
        try {
            List<ReservationCustom> reservationCustomList = reservationService.searchReservaionByuserId(reservation);
            for (ReservationCustom let : reservationCustomList) {
                let.getArea()
                        .setPrice(let.getArea().getPrice().multiply(BigDecimal.valueOf(let.getWorkTimeList().size())));
            }
            model.addAttribute("reservationCustomList", reservationCustomList);
            model.addAttribute("where", "home.jsp");
            return "user";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "error";
        }
    }

    // 修改预约的场地
    @RequestMapping("/updateReservation")
    public String updateReservation(Model model, Reservation reservation) {
        try {
            reservationService.updateReservation(reservation);
            return "reservation/userReservationList";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "reservation/userReservationList";
        }
    }

    // 取消预约的场地
    @RequestMapping("/deleteReservation")
    public String deleteReservation(Model model, Reservation reservation) {
        try {
            reservationService.deleteReservation(reservation);
            return "reservation/userReservationList";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "reservation/userReservationList";
        }
    }

    /******************** 预约场地修改开始 **************************/
    // 预定场地
    @RequestMapping("/reserveArea")
    // public String reserveArea(Model model,Reservation[] reservationList,int
    // price){
    // public String reserveArea(Model model,Reservation reservationList,int price){
    public String reserveArea(Model model, int price, HttpServletRequest request, String preDate, HttpSession session) {
        try {
            // String preDate=request.getParameter("preDate");
            // String preDate=pr
            String[] areaIdList = request.getParameterValues("areaId");
            String[] starttimeList = request.getParameterValues("starttime");
            // Date utilDate = new Date();//util.Date
            java.sql.Date sqlDate = java.sql.Date.valueOf(preDate);
            System.out.println(price);
            User user = (User) session.getAttribute("userR");
            Integer userId = user.getUserId();
            for (int i = 0; i < areaIdList.length; i++) {
                Reservation reservation = new Reservation();
                reservation.setUserId(userId);
                reservation.setAreaId(Integer.valueOf(areaIdList[i]));
                reservation.setStarttime(Integer.valueOf(starttimeList[i]));
                // if(reservation.getPreDate()==null){
                reservation.setPreDate(sqlDate);
                // }
                reservation.setPreStatus(0);
                reservation.setStoptime(reservation.getStarttime() + 1);
                // String tmpDate=String.valueOf(new Date());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String tmpDate = sdf.format(new Date());
                reservation.setPrimarykry(tmpDate);
                reservationService.saveReservation(reservation);
            }
            // System.out.println(reservationList);
            // for (Reservation reservation: reservationList) {
            // if(reservation.getPreDate()==null){
            // reservation.setPreDate(sqlDate);
            // }
            // reservation.setPreStatus(0);
            // reservation.setStoptime(reservation.getStarttime()+1);
            // reservationService.saveReservation(reservation);
            // }
            // Model model=new ;

            // this.searchReservation(model,);
            Reservation reservation1 = new Reservation();
            reservation1.setUserId(userId);
            List<ReservationCustom> reservationCustomList = reservationService.searchReservaionByuserId(reservation1);
            for (ReservationCustom let : reservationCustomList) {
                let.getArea()
                        .setPrice(let.getArea().getPrice().multiply(BigDecimal.valueOf(let.getWorkTimeList().size())));
            }
            model.addAttribute("reservationCustomList", reservationCustomList);
            model.addAttribute("where", "home.jsp");
            return "user";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "error";
        }
    }

    // 查看场地的预定情况
    @RequestMapping(value = "/searchAreaReservation")
    public String searchAreaReservation(Model model, HttpSession session, HttpServletRequest request) {
        try {
            Reservation reservation1 = new Reservation();
            String pDate = request.getParameter("pDate");
            System.out.println("pDate:" + pDate);
            java.sql.Date sqlDate;
            if (session.getAttribute("userR") == null) {
                return "redirect:/jump/ToLogin";
            }

            if (pDate == null) {
                Date utilDate = new Date();// util.Date
                // System.out.println("utilDate : " + utilDate);
                // util.Date转sql.Date
                sqlDate = new java.sql.Date(utilDate.getTime());
                // pDate=String.valueOf(sqlDate);

                reservation1.setPreDate(sqlDate);
                // System.out.println("sqlDate : " + sqlDate);
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                pDate = sdf.format(date);
            } else {
                sqlDate = java.sql.Date.valueOf(pDate);
                reservation1.setPreDate(sqlDate);
            }
            model.addAttribute("curDate", pDate);
            System.out.println("result:" + sqlDate);
            List<AreaCustom> areaCustomList = areaService.selectAreaReservation(reservation1);

            for (AreaCustom areacustom : areaCustomList) {
                Integer[] time_status = areacustom.getTime_status();
                for (int i = 0; i < 13; i++) {
                    time_status[i] = -1;
                }
                for (Reservation reservation : areacustom.getReservationList()) {
                    User this_user = (User) session.getAttribute("userR");
                    Integer th_userId = this_user.getUserId();
                    if (th_userId.equals(reservation.getUserId())) {
                        switch (reservation.getStarttime()) {
                            case 8:
                                time_status[0] = reservation.getPreStatus();
                                break;
                            case 9:
                                time_status[1] = reservation.getPreStatus();
                                break;
                            case 10:
                                time_status[2] = reservation.getPreStatus();
                                break;
                            case 11:
                                time_status[3] = reservation.getPreStatus();
                                break;
                            case 12:
                                time_status[4] = reservation.getPreStatus();
                                break;
                            case 13:
                                time_status[5] = reservation.getPreStatus();
                                break;
                            case 14:
                                time_status[6] = reservation.getPreStatus();
                                break;
                            case 15:
                                time_status[7] = reservation.getPreStatus();
                                break;
                            case 16:
                                time_status[8] = reservation.getPreStatus();
                                break;
                            case 17:
                                time_status[9] = reservation.getPreStatus();
                                break;
                            case 18:
                                time_status[10] = reservation.getPreStatus();
                                break;
                            case 19:
                                time_status[11] = reservation.getPreStatus();
                                break;
                            case 20:
                                time_status[12] = reservation.getPreStatus();
                                break;
                        }
                    } else {
                        switch (reservation.getStarttime()) {
                            case 8:
                                time_status[0] = 3;
                                break;
                            case 9:
                                time_status[1] = 3;
                                break;
                            case 10:
                                time_status[2] = 3;
                                break;
                            case 11:
                                time_status[3] = 3;
                                break;
                            case 12:
                                time_status[4] = 3;
                                break;
                            case 13:
                                time_status[5] = 3;
                                break;
                            case 14:
                                time_status[6] = 3;
                                break;
                            case 15:
                                time_status[7] = 3;
                                break;
                            case 16:
                                time_status[8] = 3;
                                break;
                            case 17:
                                time_status[9] = 3;
                                break;
                            case 18:
                                time_status[10] = 3;
                                break;
                            case 19:
                                time_status[11] = 3;
                                break;
                            case 20:
                                time_status[12] = 3;
                                break;
                        }
                    }
                    areacustom.setTime_status(time_status);
                }
            }
            model.addAttribute("areaCustomList", areaCustomList);
            model.addAttribute("where", "book.jsp");
            System.out.println(areaCustomList);
            return "book";
        } catch (Exception e) {
            model.addAttribute("error", e.getMessage());
            return "error";
        }
    }

    /******************** 预约场地修改休止 **************************/

    /* 支付界面 */
    @RequestMapping("/payMoney")
    @ResponseBody
    public String PayMoney(HttpSession session, String price, String areanem, Integer reservationId) throws Exception {
        User user = (User) session.getAttribute("userR");
        user = userService.findUserLogin(user);
        if (StringUtil.isNotEmpty(user.getBalance()) && Float.parseFloat(user.getBalance()) > 0) {
            float balance = Float.parseFloat(user.getBalance());
            if (balance < Float.parseFloat(price)) {
                return "1";// 余额不足
            }

            float sy = balance - Float.parseFloat(price);
            user.setBalance(sy + "");
            userService.updateUser(user);
            Reservation reservation = new Reservation();
            reservation.setReservationId(reservationId);
            reservationService.updateReservationPaySuccess(reservation);
            return "0";
        } else {
            return "1";
        }
    }

}
